unit uConst;

interface

uses Messages;

const
  ObjMarker = '^@@^';
  ObjMarkerLen = length(ObjMarker);
  DlgPropMarker = '^@=';
  DlgPropMarkerLen = length(DlgPropMarker);
  NoTextMarker = '<@>';

  { User defined messages used by CPRS }
//  UM_SHOWPAGE     = (WM_USER + 100);  // originally in fFrame
//  UM_NEWORDER     = (WM_USER + 101);  // originally in fODBase
//  UM_TAKEFOCUS    = (WM_USER + 102);  // in fProbEdt
//  UM_CLOSEPROBLEM = (WM_USER + 103);  // in fProbs
//  UM_PLFILTER     = (WM_USER + 104);  // in fProbs
//  UM_PLLEX        = (WM_USER + 105);  // in fProbs
//  UM_RESIZEPAGE   = (WM_USER + 107);  // originally in fPage
//  UM_DROPLIST     = (WM_USER + 108);  // originally in fODMedIn
//  UM_DESTROY      = (WM_USER + 109);  // used to notify owner when order dialog closes
//  UM_DELAYEVENT   = (WM_USER + 110);  // used with PostMessage to slightly delay an event

  UM_SHOWPAGE     = (WM_USER + 9236);  // originally in fFrame
  UM_NEWORDER     = (WM_USER + 9237);  // originally in fODBase
  UM_TAKEFOCUS    = (WM_USER + 9238);  // in fProbEdt
  UM_CLOSEPROBLEM = (WM_USER + 9239);  // in fProbs
  UM_PLFILTER     = (WM_USER + 9240);  // in fProbs
  UM_PLLEX        = (WM_USER + 9241);  // in fProbs
  UM_RESIZEPAGE   = (WM_USER + 9242);  // originally in fPage
  UM_DROPLIST     = (WM_USER + 9243);  // originally in fODMedIn
  UM_DESTROY      = (WM_USER + 9244);  // used to notify owner when order dialog closes
  UM_DELAYEVENT   = (WM_USER + 9245);  // used with PostMessage to slightly delay an event
  UM_INITIATE     = (WM_USER + 9246);  // used by fFrame to do initial stuff after FormCreate
  UM_RESYNCREM    = (WM_USER + 9247);  // used by fReminderDialog to update reminder controls

  { Changes object item types }
  CH_DOC = 10;                        // TIU documents (progress notes)
  CH_SUM = 12;                        // Discharge Summaries       {*REV*}
  CH_CON = 15;                        // Consults
  CH_ORD = 20;                        // Orders
  CH_PCE = 30;                        // Encounter Form items

  { Changes object signature requirements }
  CH_SIGN_YES = 1;                    // Obtain signature (checkbox is checked)
  CH_SIGN_NO  = 2;                    // Don't obtain signature (checkbox is unchecked)
  CH_SIGN_NA  = 0;                    // Signature not applicable (checkbox is greyed)

  { Sign & release orders }
  SS_ONCHART  = '0';
  SS_ESIGNED  = '1';
  SS_UNSIGNED = '2';
  SS_NOTREQD  = '3';
  RS_HOLD     = '0';
  RS_RELEASE  = '1';
  NO_PROVIDER = 'E';
  NO_VERBAL   = 'V';
  NO_PHONE    = 'P';
  NO_POLICY   = 'I';
  NO_WRITTEN  = 'W';

  { Actions on orders }
  ORDER_NEW   = 0;
  ORDER_DC    = 1;
  ORDER_RENEW = 2;
  ORDER_HOLD  = 3;
  ORDER_EDIT  = 4;
  ORDER_COPY  = 5;
  ORDER_QUICK = 9;
  ORDER_ACT   = 10;
  ORDER_SIGN  = 11;

  { Order action codes }
  OA_COPY     = 'RW';
  OA_CHANGE   = 'XX';
  OA_RENEW    = 'RN';
  OA_HOLD     = 'HD';
  OA_DC       = 'DC';
  OA_UNHOLD   = 'RL';
  OA_FLAG     = 'FL';
  OA_UNFLAG   = 'UF';
  OA_COMPLETE = 'CP';
  OA_ALERT    = 'AL';
  OA_REFILL   = 'RF';
  OA_VERIFY   = 'VR';
  OA_CHART    = 'CR';
  OA_RELEASE  = 'RS';
  OA_SIGN     = 'ES';
  OA_ONCHART  = 'OC';
  OA_COMMENT  = 'CM';
  OA_TRANSFER = 'XFR';

  { Ordering Dialog Form IDs }
  OD_ACTIVITY  = 100;
  OD_ALLERGY   = 105;
  OD_CONSULT   = 110;
  OD_PROCEDURE = 112;
  OD_DIET_TXT  = 115;
  OD_DIET      = 117;
  OD_LAB       = 120;
  OD_MEDINPT   = 130;
  OD_MEDS      = 135;
  OD_MEDOUTPT  = 140;
  OD_NURSING   = 150;
  OD_MISC      = 151;
  OD_GENERIC   = 152;
  OD_IMAGING   = 160;
  OD_VITALS    = 171;  // use 170 for ORWD GENERIC VITALS, 171 for GMRVOR
  OD_MEDIV     = 180;
  OD_TEXTONLY  = 999;
  OM_NAV       = 1001;
  OM_QUICK     = 1002;
  OM_TABBED    = 1003;
  OM_TREE      = 1004;
  OM_ALLERGY   = 1105;
  OD_AUTOACK   = 9999;

  { Ordering role }
  OR_NOKEY     = 0;
  OR_CLERK     = 1;
  OR_NURSE     = 2;
  OR_PHYSICIAN = 3;
  OR_STUDENT   = 4;
  OR_BADKEYS   = 5;

  { Quick Orders }
  QL_DIALOG = 0;
  QL_AUTO   = 1;
  QL_VERIFY = 2;
  QL_REJECT = 8;
  QL_CANCEL = 9;
  MAX_KEYVARS = 10;

  { Order Signature Statuses }
  OSS_UNSIGNED = 2;
  OSS_NOT_REQUIRE = 3;

  { Special Strings }
  TX_WPTYPE = '^WP^';                 // used to identify fields passed as word processing

  { Pharmacy Variables }
  PST_UNIT_DOSE  = 'U';
  PST_IV_FLUIDS  = 'F';
  PST_OUTPATIENT = 'O';

  { Status groups for medications }
  MED_ACTIVE     = 0;                 // status is an active status (active, hold, on call)
  MED_PENDING    = 1;                 // status is a pending status (non-verified)
  MED_NONACTIVE  = 2;                 // status is a non-active status (expired, dc'd, ...)

  { Actions for medications }
  MED_NONE       = 0;
  MED_NEW        = 1;
  MED_DC         = 2;
  MED_HOLD       = 3;
  MED_RENEW      = 4;
  MED_REFILL     = 5;

  { Validate Date/Times }
  DT_FUTURE   = 'F';
  DT_PAST     = 'P';
  DT_MMDDREQ  = 'E';
  DT_TIMEOPT  = 'T';
  DT_TIMEREQ  = 'R';

  { Change Context Types }
  CC_CLICK        = 0;
  CC_INIT_PATIENT = 1;
  CC_NOTIFICATION = 2;
  CC_REFRESH      = 3;
  CC_RESUME       = 4;

  { Notification Types }
  NF_LAB_RESULTS                   = 3;
  NF_FLAGGED_ORDERS                = 6;
  NF_ORDER_REQUIRES_ELEC_SIGNATURE = 12;
  NF_ABNORMAL_LAB_RESULTS          = 14;
  NF_IMAGING_RESULTS               = 22;
  NF_CONSULT_REQUEST_RESOLUTION    = 23;
  NF_ABNORMAL_IMAGING_RESULTS      = 25;
  NF_IMAGING_REQUEST_CANCEL_HELD   = 26;
  NF_NEW_SERVICE_CONSULT_REQUEST   = 27;
  NF_CONSULT_REQUEST_CANCEL_HOLD   = 30;
  NF_SITE_FLAGGED_RESULTS          = 32;
  NF_ORDERER_FLAGGED_RESULTS       = 33;
  NF_ORDER_REQUIRES_COSIGNATURE    = 37;
  NF_LAB_ORDER_CANCELED            = 42;
  NF_STAT_RESULTS                  = 44;
  NF_DNR_EXPIRING                  = 45;
  NF_MEDICATIONS_EXPIRING          = 47;
  NF_UNVERIFIED_MEDICATION_ORDER   = 48;
  NF_NEW_ORDER                     = 50;
  NF_IMAGING_RESULTS_AMENDED       = 53;
  NF_CRITICAL_LAB_RESULTS          = 57;
  NF_UNVERIFIED_ORDER              = 59;
  NF_FLAGGED_OI_RESULTS            = 60;
  NF_FLAGGED_OI_ORDER              = 61;
  NF_DC_ORDER                      = 62;
  NF_CONSULT_REQUEST_UPDATED       = 63;
  NF_FLAGGED_OI_EXP_INPT           = 64;
  NF_FLAGGED_OI_EXP_OUTPT          = 65;
  NF_CONSULT_PROC_INTERPRETATION   = 66;
  NF_DCSUMM_UNSIGNED_NOTE          = 901;
  NF_CONSULT_UNSIGNED_NOTE         = 902;
  NF_NOTES_UNSIGNED_NOTE           = 903;
  
  { Notify Application Events }
  NAE_OPEN   = 'BEG';
  NAE_CLOSE  = 'END';
  NAE_NEWPT  = 'XPT';
  NAE_REPORT = 'RPT';
  NAE_ORDER  = 'ORD';

  { TIU Delete Document Reasons }
  DR_PRIVACY = 'P';
  DR_ADMIN   = 'A';
  DR_NOTREQ  = '';
  DR_CANCEL  = 'CANCEL';

  { TIU Document Types }
  TYP_PROGRESS_NOTE =   3;
  TYP_ADDENDUM      =  81;
  TYP_DC_SUMM       = 244;

  { TIU View Contexts }
  NC_RECENT     = 0;                             // Note context - last n signed notes
  NC_ALL        = 1;                             // Note context - all signed notes
  NC_UNSIGNED   = 2;                             // Note context - all unsigned notes
  NC_UNCOSIGNED = 3;                             // Note context - all uncosigned notes
  NC_BY_AUTHOR  = 4;                             // Note context - signed notes by author
  NC_BY_DATE    = 5;                             // Note context - signed notes by date range
  NC_CUSTOM     = 6;                             // Note Context - custom view

  { TIU TreeView icons }
  IMG_TOP_LEVEL     = 0;
  IMG_GROUP_SHUT    = 1;
  IMG_GROUP_OPEN    = 2;
  IMG_SINGLE        = 3;
  IMG_PARENT        = 4;
  IMG_IDNOTE_SHUT   = 5;
  IMG_IDNOTE_OPEN   = 6;
  IMG_IDPAR_ADDENDA_SHUT = 7;
  IMG_IDPAR_ADDENDA_OPEN = 8;
  IMG_ID_CHILD      = 9;
  IMG_ID_CHILD_ADD  = 10;
  IMG_ADDENDUM      = 11;

  { Consults Treeview Icons }
  IMG_GMRC_TOP_LEVEL     = 0;
  IMG_GMRC_GROUP_SHUT    = 1;
  IMG_GMRC_GROUP_OPEN    = 2;
  IMG_GMRC_CONSULT       = 3;
  IMG_GMRC_PROC          = 4;
  IMG_GMRC_CLINPROC      = 5;
  IMG_GMRC_ALL_PROC      = 6;

  { TIU Imaging icons }
  IMG_NO_IMAGES     = 4;
  IMG_1_IMAGE       = 1;
  IMG_2_IMAGES      = 2;
  IMG_MANY_IMAGES   = 3;


  { TIU ListView sort indicators }
  IMG_NONE       = -1;
  IMG_ASCENDING  =  12;
  IMG_DESCENDING =  13;
  IMG_BLANK      =  14;

   { TIU TreeView tab indexes}
  CT_NOTES    =  6;                             // chart tab - progress notes
  CT_CONSULTS =  7;                             // chart tab - consults
  CT_DCSUMM   =  8;                             // chart tab - discharge summaries

  { TIU TreeView context strings}
  NC_TV_TEXT: array[CT_NOTES..CT_DCSUMM] of array[NC_ALL..NC_BY_DATE] of string =
    (('All signed notes','All unsigned notes','All uncosigned notes','Signed notes by author','Signed notes by date range'),
     ('Related Documents',' ',' ',' ',' '),
     ('All signed summaries','All unsigned summaries','All uncosigned summaries','Signed summaries by author','Signed summaries by date range'));

  CC_ALL        = 1;                             // Consult context - all Consults
  CC_BY_STATUS  = 2;                             // Consult context - Consults by Status
  CC_BY_SERVICE = 4;                             // Consult context - Consults by Service
  CC_BY_DATE    = 5;                             // Consult context - Consults by date range
  CC_CUSTOM     = 6;                             // Custom consults list

  CC_TV_TEXT: array[CC_ALL..CC_CUSTOM] of string =
    ('All consults','Consults by Status', '', 'Consults by Service','Consults by Date Range','Custom List');

  { New Person Filters }
  NPF_ALL       = 0;
  NPF_PROVIDER  = 1;
//  NPF_ENCOUNTER = 2;
  NPF_SUPPRESS  = 9;

  { Location Types }
  LOC_ALL      = 0;
  LOC_OUTP     = 1;
  LOC_INP      = 2;

  UpperCaseLetters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  LowerCaseLetters = 'abcdefghijklmnopqrstuvwxyz';
  Digits = '0123456789';

  //sme//MAX_ENTRY_WIDTH = 74;
  MAX_ENTRY_WIDTH = 130;

var
  ScrollBarWidth: integer = 0;

implementation

uses
  Windows;
  
initialization
  ScrollBarWidth := GetSystemMetrics(SM_CXVSCROLL);

end.
